// __multiversion__
// This signals the loading code to prepend either #version 100 or #version 300 es as apropriate.

#include "fragmentVersionCentroid.h"

#if __VERSION__ >= 300
#if defined(TEXEL_AA) && defined(TEXEL_AA_FEATURE)
_centroid in highp vec2 uv;
#else
_centroid in vec2 uv;
#endif

#else
varying vec2 uv;
#endif

#include "uniformWorldConstants.h"
#include "uniformPerFrameConstants.h"
#include "uniformShaderConstants.h"
#include "uniformRenderChunkConstants.h"
#include "util.h"

/////////////////////////////////////////////////////////////////
///////////////////////// STOP! /////////////////////////////////
/////////////////////////////////////////////////////////////////
// Made by @Bicubicpack.
// successfully changed (modified and optimalized) on 7 oct 2020.
// all of these assets are under MIT license.
/////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////

varying highp vec3 pos;

LAYOUT_BINDING(0) uniform sampler2D TEXTURE_0;

void main()
{

#if !defined(TEXEL_AA) || !defined(TEXEL_AA_FEATURE)
	vec4 diffuse = texture2D( TEXTURE_0, uv );
#else
	vec4 diffuse = texture2D_AA(TEXTURE_0, uv );
#endif

	highp vec2 ftime = vec2(pow(max(min(1.0-FOG_COLOR.r*1.5,1.),.0),1.2),pow(max(min(1.0-FOG_COLOR.r*1.2,1.),.0),.5));

	float size = mix(mix(1.8,1.5,ftime.y), 0.9,ftime.x);
	float b = length(pos.xz)*CURRENT_COLOR.r;

	vec3 res = mix(vec3(1.0, 0.8, 0.0), vec3(1.0, 0.5, 0.7) + FOG_COLOR.r, ftime.y);
		res = mix(res, vec3(1.0) *1.2 + FOG_COLOR.r + FOG_COLOR.r,ftime.x);
		res += max(0.1 / pow(length(pos.xz*size) * 4.0, 8.0), 0.0) + abs(b * 7.0)/15.0;
		res += max(0.01 / pow(length(pos.xz*size) * 1.0, 2.0 / 10.0), .0) + abs(b * 13.0)/20.0;
		res += (max(0.01 / pow(length(pos.xz*size) * 20.0, 1.0 / 2.0), 0.0)*4.0)*4.0;
		res *= exp(0.5 - length(pos.xz)) / mix(7.0,9.,ftime.x);

	diffuse.rgb = res*CURRENT_COLOR.rgb;

gl_FragColor = diffuse;
gl_FragColor.a = 1.0*pow(FOG_CONTROL.y, 10.0);
}
